<style>
    .error-msg {
        color: red;
        padding-bottom: 1rem;
    }

    .multi-image-input {
        margin-bottom: 10px;
    }

    .level h4 {
        color: red;
        font-weight: 600;
    }

    .level-table-container {
        margin-top: 20px;
        border: 1px solid #ddd;
        padding: 15px;
        border-radius: 5px;
    }

    .level-row {
        display: flex;
        flex-wrap: wrap;
        margin-bottom: 15px;
        padding-bottom: 15px;
        border-bottom: 1px solid #eee;
    }

    .level-row:last-child {
        border-bottom: none;
    }

    .level-row .col-md-3 {
        padding-right: 15px;
    }

    .remove-level {
        margin-top: 30px;
    }

    .hidden-qty-field {
        display: none;
    }
</style>

<?php
include '../include/header.php';
include '../include/side_bar.php';
include '../include/function.inc.php';

$id = "";
$categories = "";
$name = "";
$image = "";
$pdf = "";
$author = "";
$released = "";
$price = "";
$mrp = "";
$qty = "";
$brands = "";
$offer = "";
$short_desc = "";
$long_desc = "";
$meta_title = "";
$meta_desc = "";
$meta_key = "";
$url = "";
$msg = "";
$multi_image = [];

function generateSlug($string)
{
    $slug = strtolower(trim($string));
    $slug = preg_replace('/[^a-z0-9-]/', '-', $slug);
    $slug = preg_replace('/-+/', '-', $slug);
    return rtrim($slug, '-');
}

if (isset($_GET['id']) && !empty($_GET['id'])) {
    $id = mysqli_real_escape_string($conn, $_GET['id']);
    $sql = "SELECT * FROM `product` WHERE id = '$id'";
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $categories = $row['categories_id'];
        $name = $row['name'];
        $image = $row['image'];
        $pdf = $row['pdf'];
        $author = $row['author'];
        $released = $row['released'];
        $price = $row['price'];
        $mrp = $row['mrp'];
        $qty = $row['qty'];
        $brands = $row['brands'];
        $offer = $row['offer'];
        $short_desc = $row['short_desc'];
        $long_desc = $row['long_desc'];
        $meta_title = $row['meta_title'];
        $meta_desc = $row['meta_desc'];
        $meta_key = $row['meta_key'];
        $url = $row['url'];
    } else {
        echo "<script>window.location.href = 'product.php';</script>";
        exit;
    }

    // Get multi images
    $sql = "SELECT * FROM multi_img WHERE services_id = '$id'";
    $result = mysqli_query($conn, $sql);
    while ($row = mysqli_fetch_assoc($result)) {
        $multi_image[] = ['id' => $row['id'], 'file' => $row['multi_image']];
    }
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $id = mysqli_real_escape_string($conn, $_POST['id']);
    $categories = mysqli_real_escape_string($conn, $_POST['categories']);
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $author = mysqli_real_escape_string($conn, $_POST['author']);
    $released = mysqli_real_escape_string($conn, $_POST['released']);
    $price = mysqli_real_escape_string($conn, $_POST['price']);
    $mrp = mysqli_real_escape_string($conn, $_POST['mrp']);
    $qty = mysqli_real_escape_string($conn, $_POST['qty']);
    $brands = mysqli_real_escape_string($conn, $_POST['brands']);
    $offer = mysqli_real_escape_string($conn, $_POST['offer']);
    $short_desc = mysqli_real_escape_string($conn, $_POST['short_desc']);
    $long_desc = mysqli_real_escape_string($conn, $_POST['long_desc']);
    $meta_title = mysqli_real_escape_string($conn, $_POST['meta_title']);
    $meta_desc = mysqli_real_escape_string($conn, $_POST['meta_desc']);
    $meta_key = mysqli_real_escape_string($conn, $_POST['meta_key']);

    $url = generateSlug($name);

    $res = mysqli_query($conn, "select * from product where name = '$name'");
    $check = mysqli_num_rows($res);
    if ($check > 0) {
        if (isset($_GET['id']) && $_GET['id'] != '') {
            $getData = mysqli_fetch_assoc($res);
            if ($id == $getData['id']) {
                // This is an update of the same record, so it's okay
            } else {
                $msg = "Product Already Exists";
            }
        } else {
            $msg = "Product Already Exists";
        }
    }


    $pdf_name = $pdf; // default to existing PDF

    if (isset($_FILES['pdf']) && $_FILES['pdf']['name'] != '') {
        $pdf_name = time() . '_' . $_FILES['pdf']['name'];
        $pdf_dir = "../pdf/";
        $pdf_file = $pdf_dir . basename($pdf_name);
        move_uploaded_file($_FILES['pdf']['tmp_name'], $pdf_file);
    }


    $image_name = $image;

    // Handle Image Upload
    if (isset($_FILES['image']) && $_FILES['image']['name'] != '') {
        $image_name = time() . '_' . $_FILES['image']['name'];
        $target_dir = "../uploads/";
        $target_file = $target_dir . basename($image_name);
        move_uploaded_file($_FILES['image']['tmp_name'], $target_file);
    }

    if ($msg === '') {
        if (!empty($id)) {
            $sql = "UPDATE `product` SET 
    categories_id='$categories', name='$name', image='$image_name', pdf='$pdf_name',
    author='$author', released='$released', price='$price', mrp='$mrp', 
    qty='$qty', brands='$brands', offer='$offer', short_desc='$short_desc', 
    long_desc='$long_desc', meta_title='$meta_title', meta_desc='$meta_desc', 
    meta_key='$meta_key', url='$url'
    WHERE id='$id'";

            $action = "updated";
        } else {
            $sql = "INSERT INTO `product` 
    (categories_id, name, image, pdf, author, released, price, mrp, qty, 
    brands, offer, short_desc, long_desc, meta_title, meta_desc, meta_key, url) 
    VALUES 
    ('$categories', '$name', '$image_name', '$pdf_name', '$author', '$released', '$price', 
    '$mrp', '$qty', '$brands', '$offer', '$short_desc', '$long_desc', 
    '$meta_title', '$meta_desc', '$meta_key', '$url')";

            $action = "inserted";
        }

        if (mysqli_query($conn, $sql)) {
            if (!$id) {
                $id = mysqli_insert_id($conn);
            }

            // Handle multi-image uploads
            if (!empty($_FILES['multi_image']['name'][0])) {
                foreach ($_FILES['multi_image']['name'] as $key => $value) {
                    if ($_FILES['multi_image']['error'][$key] == 0) {
                        $multiImageName = time() . "_" . basename($_FILES['multi_image']['name'][$key]);
                        $target_path = "../uploads/" . $multiImageName;
                        if (move_uploaded_file($_FILES['multi_image']['tmp_name'][$key], $target_path)) {
                            mysqli_query($conn, "INSERT INTO multi_img (services_id, multi_image) VALUES ('$id', '$multiImageName')");
                        }
                    }
                }
            }

            // Handle deletion of existing images
            if (isset($_POST['delete_multi_image']) && !empty($_POST['delete_multi_image'])) {
                foreach ($_POST['delete_multi_image'] as $deleteImageId) {
                    $deleteImageId = mysqli_real_escape_string($conn, $deleteImageId);
                    $result = mysqli_query($conn, "SELECT multi_image FROM multi_img WHERE id = '$deleteImageId'");
                    if ($row = mysqli_fetch_assoc($result)) {
                        $imagePath = "../uploads/" . $row['multi_image'];
                        if (file_exists($imagePath)) {
                            unlink($imagePath);
                        }
                        mysqli_query($conn, "DELETE FROM multi_img WHERE id = '$deleteImageId'");
                    }
                }
            }

            echo "<script>alert('Record saved successfully!'); window.location.href = 'product.php';</script>";
            exit;
        } else {
            echo "<script>alert('Error: " . mysqli_error($conn) . "');</script>";
        }
    }
}
?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3><?php echo $id ? 'Edit' : 'Add'; ?> Product</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Products</p>
            </div>
        </div>

        <div class="category_wrapper">
            <form action="" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Category</label>
                        <select name="categories" class="form-select">
                            <option value="">Select Category</option>
                            <?php
                            $cat_result = mysqli_query($conn, "SELECT id, categories FROM categories ORDER BY categories DESC");
                            while ($cat_row = mysqli_fetch_assoc($cat_result)) {
                                $selected = $categories == $cat_row['id'] ? 'selected' : '';
                                echo "<option value='" . $cat_row['id'] . "' $selected>" . $cat_row['categories'] . "</option>";
                            }
                            ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Product Name</label>
                        <input type="text" name="name" class="form-control"
                            value="<?php echo htmlspecialchars($name); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Author</label>
                        <input type="text" name="author" class="form-control"
                            value="<?php echo htmlspecialchars($author); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Released Date</label>
                        <input type="date" name="released" class="form-control"
                            value="<?php echo htmlspecialchars($released); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Price</label>
                        <input type="text" name="price" class="form-control"
                            value="<?php echo htmlspecialchars($price); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">MRP</label>
                        <input type="text" name="mrp" class="form-control"
                            value="<?php echo htmlspecialchars($mrp); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Quantity</label>
                        <input type="text" name="qty" class="form-control"
                            value="<?php echo htmlspecialchars($qty); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Brands</label>
                        <input type="text" name="brands" class="form-control"
                            value="<?php echo htmlspecialchars($brands); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Offer (%)</label>
                        <input type="text" name="offer" class="form-control"
                            value="<?php echo htmlspecialchars($offer); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Image</label>
                        <input type="file" name="image" class="form-control">
                        <?php if ($image): ?>
                            <img src='../uploads/<?php echo $image; ?>' width='50' style='margin-top:10px;'>
                            <input type="hidden" name="existing_image" value="<?php echo $image; ?>">
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">PDF</label>
                        <input type="file" name="pdf" class="form-control">
                        <?php if ($pdf): ?>
                            <a href='../pdf/<?php echo $pdf; ?>' target="_blank" style='display:block;margin-top:10px;'>View
                                PDF</a>
                            <input type="hidden" name="existing_pdf" value="<?php echo $pdf; ?>">
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Short Description</label>
                        <textarea name="short_desc"
                            class="form-control"><?php echo htmlspecialchars($short_desc); ?></textarea>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Long Description</label>
                        <textarea name="long_desc"
                            class="form-control"><?php echo htmlspecialchars($long_desc); ?></textarea>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Meta Title</label>
                        <input type="text" name="meta_title" class="form-control"
                            value="<?php echo htmlspecialchars($meta_title); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Meta Description</label>
                        <input type="text" name="meta_desc" class="form-control"
                            value="<?php echo htmlspecialchars($meta_desc); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Meta Keywords</label>
                        <input type="text" name="meta_key" class="form-control"
                            value="<?php echo htmlspecialchars($meta_key); ?>">
                    </div>

                    <div class="col-12 mb-3">
                        <label class="form-label">Multiple Images</label>
                        <div id="multi-image-container">
                            <?php foreach ($multi_image as $img): ?>
                                <div class="multi-image-input d-flex align-items-center mb-2">
                                    <img src="../uploads/<?php echo $img['file']; ?>" width="50" class="me-3">
                                    <input type="hidden" name="existing_multi_image[]" value="<?php echo $img['file']; ?>">
                                    <button type="button" class="btn btn-danger remove-image"
                                        data-id="<?php echo $img['id']; ?>">Remove</button>
                                    <input type="hidden" name="delete_multi_image[]" value="" class="delete-flag">
                                </div>
                            <?php endforeach; ?>

                            <div class="multi-image-input">
                                <input type="file" name="multi_image[]" class="form-control mb-2">
                                <button type="button" class="btn btn-success add-image">Add More Images</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="error-msg"><?php echo $msg; ?></div>
                <button type="submit" name="submit" class="btn btn-primary mt-3">
                    <?php echo $id ? 'Update' : 'Submit'; ?>
                </button>
            </form>
        </div>
    </div>
</main>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Add more image fields dynamically
        document.addEventListener('click', function (e) {
            if (e.target.classList.contains('add-image')) {
                const container = document.getElementById('multi-image-container');
                const newInput = document.createElement('div');
                newInput.className = 'multi-image-input mt-2';
                newInput.innerHTML = `
                    <input type="file" name="multi_image[]" class="form-control mb-2">
                    <button type="button" class="btn btn-danger remove-new-image">Remove</button>
                `;
                container.insertBefore(newInput, e.target.parentNode);
            }

            // Remove new image fields (not yet saved)
            if (e.target.classList.contains('remove-new-image')) {
                e.target.parentNode.remove();
            }

            // Mark existing images for deletion
            if (e.target.classList.contains('remove-image')) {
                const imageId = e.target.getAttribute('data-id');
                const parentDiv = e.target.closest('.multi-image-input');
                const deleteInput = parentDiv.querySelector('.delete-flag');

                // Set the value to be deleted
                deleteInput.value = imageId;

                // Hide the element (we'll still submit the delete flag)
                parentDiv.style.display = 'none';
            }
        });
    });
</script>

<?php include '../include/footer.php'; ?>