<?php include '../include/header.php'; ?>
<?php include '../include/side_bar.php'; ?>

<main class="dashboard-main">
    <?php include '../include/top_bar.php'; ?>
    <div class="dashboard-main-body">
        <div class="dashboard_heading">
            <h3>View Video</h3>
            <div class="dashboard_heading__right">
                <a href="/">Home</a> <span>/</span>
                <p>Video</p>
            </div>
        </div>

        <div class="salary_wrapper">
            <div class="salary_header">
                <h5>Video</h5>
                <div class="salary_header__right">
                    <a href="add-video.php"><i class="fa-solid fa-plus"></i> Add Video</a>
                </div>
            </div>
            <div class="salary-table">
                <div class="salary-box">
                    <table class="table table-striped">
                        <thead>
                            <tr class="table-head">
                                <th scope="col">S.NO</th>
                                <th scope="col">Video</th>
                                <th scope="col">Status</th>
                                <th scope="col">Date</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // Status / Delete handling
                            if (isset($_GET['type']) && $_GET['type'] != '') {
                                $type = $_GET['type'];

                                if ($type == 'status') {
                                    $operation = $_GET['operation'];
                                    $id = intval($_GET['id']);
                                    $status = ($operation == 'active') ? '1' : '0';
                                    mysqli_query($conn, "UPDATE video_web SET status='$status' WHERE id='$id'");
                                }

                                if ($type == 'delete') {
                                    $id = intval($_GET['id']);
                                    $result = mysqli_query($conn, "SELECT video FROM video_web WHERE id='$id'");
                                    $row = mysqli_fetch_assoc($result);

                                    if (!empty($row['video'])) {
                                        $video_path = '../uploads/' . $row['video'];
                                        if (file_exists($video_path)) {
                                            unlink($video_path);
                                        }
                                    }
                                    mysqli_query($conn, "DELETE FROM video_web WHERE id='$id'");
                                }
                            }

                            $sql = "SELECT * FROM video_web ORDER BY id DESC";
                            $result = mysqli_query($conn, $sql);
                            $sno = 0;
                            $total_records = mysqli_num_rows($result);
                            while ($row = mysqli_fetch_assoc($result)) {
                                $sno++;
                                $status = $row['status'];
                                $videoFile = !empty($row['video']) ? '../uploads/' . $row['video'] : '';
                                ?>
                                <tr>
                                    <th scope="row"><?php echo $sno; ?></th>
                                    <td>
                                        <?php if (!empty($videoFile)) { ?>
                                            <video width="50" height="50" controls>
                                                <source src="<?php echo $videoFile; ?>" type="video/mp4">
                                                Your browser does not support the video tag.
                                            </video>
                                        <?php } else { ?>
                                            <span>No Video</span>
                                        <?php } ?>
                                    </td>
                                    <td>
                                        <?php
                                        if ($status == '1') {
                                            echo "<span class='btn btn-round btn-warning'><a style='color:#fff;' href='?type=status&operation=deactive&id=" . $row['id'] . "'>Deactivate</a></span>";
                                        } else {
                                            echo "<span class='btn btn-round btn-success'><a style='color:#fff;' href='?type=status&operation=active&id=" . $row['id'] . "'>Activate</a></span>";
                                        }
                                        ?>
                                    </td>
                                    <td><?php echo $row['date']; ?></td>
                                    <td>
                                        <a href="add-video.php?id=<?php echo $row['id']; ?>" class="edit">Edit</a>
                                        <a href="?type=delete&id=<?php echo $row['id']; ?>" class="delete"
                                            onclick="return confirm('Please confirm deletion');">Delete</a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <div class="salary-box-bottom">
                        <p>Showing 1 to <?php echo $sno; ?> of <?php echo $total_records; ?> entries</p>
                        <div class="next-prev">
                            <button>Previous</button>
                            <p>1</p>
                            <button>Next</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../include/footer.php'; ?>